% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t.R
\name{iscaminvt}
\alias{iscaminvt}
\title{Inverse T Calculation}
\usage{
iscaminvt(prob, df, direction, verbose = TRUE)
}
\arguments{
\item{prob}{Desired probability.}

\item{df}{Degrees of freedom}

\item{direction}{direction for probability calculation: "above", "below",
"outside", "between".}

\item{verbose}{Logical, defaults to \code{TRUE}. Set to \code{FALSE} to suppress messages}
}
\value{
The t value for the specified probability.
}
\description{
\code{invt} calculates the t quantile of a specified probability.
}
\examples{
iscaminvt(0.05, df = 15, direction = "below")
iscaminvt(0.10, df = 25, direction = "above")
iscaminvt(0.95, df = 30, direction = "between")
iscaminvt(0.05, df = 20, direction = "outside")
}
