% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial.R
\name{iscambinomprob}
\alias{iscambinomprob}
\title{Calculate Binomial Tail Probabilities}
\usage{
iscambinomprob(k, n, prob, lower.tail, verbose = TRUE)
}
\arguments{
\item{k}{number of successes of interest.}

\item{n}{number of trials.}

\item{prob}{success probability. Numeric between 0 & 1.}

\item{lower.tail}{Boolean for finding the probability above (FALSE) or below (TRUE) the inputted value (inclusive)}

\item{verbose}{Logical, defaults to \code{TRUE}. Set to \code{FALSE} to suppress messages}
}
\value{
The probability of the binomial distribution along with a graph of the distribution.
}
\description{
\code{binomprob} calculates the probability of the number of success of interest
using a binomial distribution and plots the distribution.
}
\examples{
iscambinomprob(k = 5, n = 20, prob = 0.4, lower.tail = TRUE)
iscambinomprob(k = 15, n = 30, prob = 0.3, lower.tail = FALSE)
iscambinomprob(k = 22, n = 25, prob = 0.9, lower.tail = TRUE)
}
