% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlayDensities.R
\name{iscamaddexp}
\alias{iscamaddexp}
\title{Overlay an Exponential Density Function on Histogram}
\usage{
iscamaddexp(
  x,
  main = "Histogram with exponential curve",
  xlab = deparse(substitute(x)),
  bins = NULL
)
}
\arguments{
\item{x}{A numeric vector representing the data to be plotted.}

\item{main}{Optional title for the plot}

\item{xlab}{Optional x-axis label for the plot}

\item{bins}{Optional number of bins for the histogram.}
}
\value{
A histogram of x overlayed with an exponential density function.
}
\description{
\code{addexp} creates a histogram of \code{x} and overlays an exponential density
function with \eqn{\lambda = \frac{1}{mean}}.
}
\examples{
set.seed(0)
x <- rexp(100, rate = 0.5)
iscamaddexp(x)
iscamaddexp(x, main = "Your Active Title", xlab = "Exponential Data", bins = 20)
}
