% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cchart.R.R
\name{cchart.R}
\alias{cchart.R}
\title{R control chart}
\usage{
cchart.R(x, n, type = "norm", y = NULL)
}
\arguments{
\item{x}{The data to be plotted.}

\item{n}{The sample size.}

\item{type}{The type of R chart to be plotted. The options are "norm"
(traditional Shewhart R chart) and "tukey" (exact R chart). If not
specified, a Shewhart R chart will be plotted.}

\item{y}{The data used in phase I to estimate the standard deviation.}
}
\value{
Return a R control chart.
}
\description{
This function builds a R control chart.
}
\details{
The Shewhart R chart was designed for phase I (at this moment).  The limits
of the exact R chart are the alpha/2 and 1-alpha/2 quantiles of the R
distribution that are calculated as estimated process sd times the quantiles
of the relative range (W=R/sigma) distribution.
}
\examples{

data(pistonrings)
attach(pistonrings)
cchart.R(pistonrings[1:25,], 5)
cchart.R(pistonrings[26:40, ], 5, type = "tukey", pistonrings[1:25, ])

}
\author{
Daniela R. Recchia, Emanuel P. Barbosa
}
