% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geno.d.R
\name{geno.d}
\alias{geno.d}
\title{Generate the Genetic Design Matrix with dominance Effect}
\usage{
geno.d(geno, AA = 1, Aa = 0, aa = -1)
}
\arguments{
\item{geno}{matrix. An n*p matrix denotes the commonly used additive effect
genetic design matrix of the training population.}

\item{AA}{number or character. The code denote alleles AA in the geno data.}

\item{Aa}{number or character. The code denote alleles Aa in the geno data.}

\item{aa}{number or character. The code denote alleles aa in the geno data.}
}
\value{
\item{genoA}{An n*p matrix denote additive effects, and the markers are coded
as 1, 0, or -1 for alleles AA, Aa, or aa.}
\item{genoD}{An n*p matrix denote dominance effects, and the markers are coded
as 0.5, -0.5, or 0.5 for alleles AA, Aa, or aa.}
\item{KA}{An n*n matrix denote the kinship matrix of individuals with additive
effects. Whitch is caculated by genoA.}
\item{KD}{An n*n matrix denote the kinship matrix of individuals with dominance
effects. Whitch is caculated by genoD.}
}
\description{
Input the commonly used additive effect genetic design matrix to generate the
design matrix and kinship matrix of additive and dominance effects respectively.
}
\examples{

geno <- rbind(rep(1,10),rep(0,10),rep(-1,10),c(rep(1,5),rep(-1,5)),c(rep(-1,5),rep(1,5)))
geno

geno2 <- geno.d(geno)

geno2$genoD
geno2$KD
}
\references{
Cockerham, C. C., 1954. An extension of the concept of partitioning
hereditary variance for analysis of covariances among relatives When
epistasis is present. Genetics 39: 859–882.
}
