% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repsetup.R
\name{repsetup}
\alias{repsetup}
\alias{repsetupILSA}
\title{Setup for Analysis with Replicate Weights}
\usage{
repsetup(repwt, wt, df, method, group = NULL, exclude = NULL)

repsetupILSA(study, year, repwt, df, group = NULL, exclude = NULL)
}
\arguments{
\item{repwt}{a string indicating the common names for the replicate weights
columns (within \code{df}), or a data frame with the replicate weights.}

\item{wt}{a string specifying the name of the column (within \code{df}) with the
total weights.}

\item{df}{a data frame.}

\item{method}{a string indicating the name of the replication method.
Available options are:
\code{"JK2-full"}, \code{"JK2-half"},
\code{"FAY-0.5"},
and \code{"JK2-half-1PV"}. \cr\cr
Additionally, ILSA names can be used, defaulting into:
\itemize{
\item \code{"TIMSS"} or \code{"PIRLS"} for \code{"JK2-full"};
\item \code{"ICILS"}, \code{"ICCS"}, or \code{"CIVED"} for \code{"JK2-half"};
\item \code{"PISA"} or \code{"TALIS"} for \code{"FAY-0.5"};
\item and \code{"oldTIMSS"} or \code{"oldPIRLS"} for \code{"JK2-half-1PV"}.
}
Note that \code{"oldTIMSS"} and \code{"oldPIRLS"}
refer to the method used for TIMSS and PIRLS before 2015,
where within imputation variance
is estimated using only 1 plausible value.}

\item{group}{a string specifying the variable name (within \code{df}) to be
used for grouping. Categories in \code{group} are treated as independent, e.g.,
countries.}

\item{exclude}{a vector indicating which groups
(in the same format as \code{group})
should be excluded from the pooled and composite estimates.}

\item{study}{a string indicating the study name. For checking available studies use
\code{ILSAinfo$weights}.}

\item{year}{a numeric value indicating the study year. For checking available
years use
\code{ILSAinfo$weights}.}
}
\value{
a list to be used in other functions.
}
\description{
Creates a list with common arguments used for analysis with replicate
weights.
}
\examples{
# Creation of replicate weights
RW <- repcreate(df = repdata, # the data frame with all the information
                 wt = "wt", # the total weights column name
                 jkzone = "jkzones", # the jkzones column name
                 jkrep = "jkrep", # the jkreps column name
                 repwtname = "REPWT", # the desired name for the rep weights
                 reps = 50, # the number of replications
                 method = "ICILS") # the name of the method aka the study name

### No groups ----
stp1 <- repsetup(repwt = RW, wt = "wt", df = repdata, method = "ICILS")
stp1

### Groups ----
stp2 <- repsetup(repwt = RW, wt = "wt", df = repdata, method = "ICILS",
                 group = "GROUP", exclude = "GR2")
stp2


### repmean ----

repmean(x = "Math1",setup = stp1)

repmean(x = "Math1",setup = stp2)
}
