% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repcreate.R
\name{repcreate}
\alias{repcreate}
\alias{repcreateILSA}
\title{Creation of Replicate Weights}
\usage{
repcreate(df, wt, jkzone, jkrep, repwtname = "RWT", reps = NULL, method)

repcreateILSA(study, year, df, repwtname = "RWT")
}
\arguments{
\item{df}{a data frame.}

\item{wt}{a string specifying the name of the column (within \code{df}) with the
total weights.}

\item{jkzone}{a string specifying the name of the column in \code{df}
that contains the jackknife zone information.}

\item{jkrep}{a string specifying the name of the column in \code{df}
that contains the jackknife replicate information.}

\item{repwtname}{a string specifying the variable names for the
replicate weights.}

\item{reps}{an integer indicating the number of replications to be created.
If \code{NULL} the maximum number of zones will be used.}

\item{method}{a string indicating the name of the replication method.
Available options are:
\code{"JK2-full"}, \code{"JK2-half"},
and \code{"JK2-half-1PV"}. \cr\cr
Additionally, ILSA names can be used, defaulting into:
\itemize{
\item \code{"TIMSS"} or \code{"PIRLS"} for \code{"JK2-full"};
\item \code{"ICILS"}, \code{"ICCS"}, or \code{"CIVED"} for \code{"JK2-half"};
and \code{"oldTIMSS"} or \code{"oldPIRLS"} for \code{"JK2-half-1PV"}.
}
Note that \code{"oldTIMSS"} and \code{"oldPIRLS"}
refer to the method used for TIMSS and PIRLS before 2015,
where within imputation variance
is estimated using only 1 plausible value.}

\item{study}{a string indicating the study name. For checking available studies use
\code{ILSAinfo$weights}.}

\item{year}{a numeric value indicating the study year. For checking available
years use
\code{ILSAinfo$weights}.}
}
\value{
a data frame.
}
\description{
Creates replicate weights given jackknife replicates and jackknife zones.
}
\examples{

head(repdata)

# Creation of replicate weights
RW <- repcreate(df = repdata, # the data frame with all the information
                 wt = "wt", # the total weights column name
                 jkzone = "jkzones", # the jkzones column name
                 jkrep = "jkrep", # the jkreps column name
                 repwtname = "REPWT", # the desired name for the rep weights
                 reps = 50, # the number of replications
                 method = "ICILS") # the name of the method aka the study name

head(RW)
}
