% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_modify_regions.R
\name{data_modify_regions}
\alias{data_modify_regions}
\title{Modify Populations within IFC_data Object}
\usage{
data_modify_regions(obj, regions, display_progress = TRUE, ...)
}
\arguments{
\item{obj}{an `IFC_data` object extracted by ExtractFromDAF(extract_features = TRUE) or ExtractFromXIF(extract_features = TRUE).}

\item{regions}{a list of region(s) to modify in 'obj'. Each element of this list will be coerced by \code{\link{buildRegion}}.}

\item{display_progress}{whether to display a progress bar. Default is TRUE.}

\item{...}{Other arguments to be passed.}
}
\value{
an IFC_data object with regions modified.
}
\description{
Modify populations in an already existing `IFC_data` object.
}
\details{
regions names should be present in names(obj$regions), otherwise an error will be raised.\cr
Note that If you want to rename regions, you should do it by changing 'label' member,
e.g. regions[[1]]$label <- "bar" while names(regions[[1]]) is "foo" and "foo" is part of names(obj$regions).
}
\keyword{internal}
