% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExportToNumpy.R
\name{ExportToNumpy}
\alias{ExportToNumpy}
\title{Numpy Export}
\usage{
ExportToNumpy(
  ...,
  objects,
  offsets,
  image_type = "img",
  size = c(64, 64),
  force_width = FALSE,
  display_progress = TRUE,
  python = Sys.getenv("RETICULATE_PYTHON"),
  dtype = c("uint8", "int16", "uint16", "double")[3],
  mode = c("raw", "gray")[1],
  export = c("file", "matrix")[2],
  write_to,
  overwrite = FALSE
)
}
\arguments{
\item{\dots}{arguments to be passed to \code{\link{objectExtract}} with the exception of \code{'ifd'} and \code{'bypass'}(=\strong{TRUE}).\cr
\strong{/!\\} If not any of \code{'fileName'}, \code{'info'} and \code{'param'} can be found in \code{'...'} then \code{attr(offsets, "fileName_image")} will be used as \code{'fileName'} input parameter to pass to \code{\link{objectParam}}.}

\item{objects}{integer vector, IDEAS objects ids numbers to use.
This argument is not mandatory, if missing, the default, all objects will be used.}

\item{offsets}{object of class `IFC_offset`.
This argument is not mandatory but it may allow to save time for repeated image export on same file.\cr
If \code{'offsets'} are not provided, extra arguments can also be passed with \code{'...'} to \code{\link{getOffsets}}.}

\item{image_type}{type of desired object offsets. Either \code{"img"} or \code{"msk"}. Default is \code{"img"}.}

\item{size}{a length 2 integer vector of final dimensions of the image, height 1st and width 2nd. Default is \code{c(64,64)}.}

\item{force_width}{whether to use information in \code{'info'} to fill \code{'size'}. Default is \code{FALSE}.
When set to \code{TRUE}, width of \code{'size'} argument will be overwritten.}

\item{display_progress}{whether to display a progress bar. Default is \code{TRUE}.}

\item{python}{path to python. Default is \code{Sys.getenv("RETICULATE_PYTHON")}.\cr
Note that \code{numpy} should be available in this \code{python} to allow export to \code{".npy"} file, otherwise \code{'export'} will be forced to \code{"matrix"}.}

\item{dtype}{desired arrays data-type. Default is \code{"double"}. Allowed are \code{"uint8"}, \code{"int16"}, \code{"uint16"} or \code{"double"}. If \code{'mode'} is \code{"raw"}, this parameter will be forced to \code{"int16"}.}

\item{mode}{(\code{\link{objectParam}} argument) color mode export. Either \code{"raw"}, \code{"gray"}. Default is \code{"raw"}.}

\item{export}{export format. Either \code{"file"}, \code{"matrix"}. Default is \code{"matrix"}.\cr
Note that you will need \code{reticulate} package installed to be able to export to \code{".npy"} file, otherwise \code{'export'} will be forced to \code{"matrix"}.}

\item{write_to}{used when \code{'export'} is \code{"file"} to compute exported file name and type.
Exported type will be deduced from this pattern. Allowed exported file extension is \code{".npy"}.\cr
Placeholders, if found, will be substituted:\cr
-\code{\%d}: with full path directory\cr
-\code{\%p}: with first parent directory\cr
-\code{\%e}: with extension of (without leading .)\cr
-\code{\%s}: with shortname (i.e. basename without extension)\cr
-\code{\%o}: with objects (at most 10, will be collapse with "_", if more than one).\cr
-\code{\%c}: with channel_id (will be collapse with "_", if more than one, composite in any will be bracketed).
A good trick is to use:\cr
-\code{"\%d/\%s_Obj[\%o]_Ch[\%c].npy"}, when \code{'export'} is \code{"file"}.}

\item{overwrite}{whether to overwrite file or not. Default is \code{FALSE}.}
}
\value{
Depending on \code{'export'}:\cr
-\code{"matrix"}, an array whose dimensions are [object, height, width, channel].\cr
-\code{"file"}, it invisibly returns path of \code{".npy"} exported file.
}
\description{
Exports IFC objects to numpy array [objects,height,width,channels]
}
\details{
Please note that \code{'size'} parameter has to be supplied and could not be set to (0,) when \code{'object'} length is not equal to one\cr
\code{\link{ExportToNumpy}} requires \code{reticulate} package, \code{python} and \code{numpy} installed to create \code{".npy"} file.\cr
If one of these is missing, \code{'export'} will be set to \code{"matrix"}.
If \code{'param'} is provided in \code{'...'}, \code{param$export <- "matrix"}, \code{param$mode <- 'mode'} and \code{param$size <- 'size'} and will be overwritten.
}
\note{
Arguments of \code{\link{objectExtract}} will be deduced from \code{\link{ExportToNumpy}} input arguments.
}
