% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Finalised_coding.R
\name{est_signal}
\alias{est_signal}
\title{Estimate the signal}
\usage{
est_signal(x, cpt, type = c("mean", "slope"))
}
\arguments{
\item{x}{A numeric vector containing the given data.}

\item{cpt}{A positive integer vector with the locations of the change-points.
If missing, the \code{\link{ID_pcm}} or the \code{\link{ID_cplm}} function
(depending on the type of the signal) is called internally to extract the
change-points in \code{x}.}

\item{type}{A character string, which defines the type of the detected change-points.
If \code{type = ``mean''}, then the change-points represent the locations of changes
in the mean of a piecewise-constant signal. If \code{type = ``slope''}, then the
change-points represent the locations of changes in the slope of a continuous, piecewise-linear
signal.}
}
\value{
A numeric vector with the estimated signal.
}
\description{
This function estimates the signal in a given data sequence \code{x} with change-points
at \code{cpt}. The type of the signal depends on whether the change-points represent changes
in a piecewise-constant or continuous, piecewise-linear signal. For more information see
Details below.
}
\details{
The data points provided in \code{x} are assumed to follow \deqn{X_t = f_t + \sigma\epsilon_t; t = 1,2,...,T,}
  where \eqn{T} is the total length of the data sequence, \eqn{X_t} are the observed
  data, \eqn{f_t} is a one-dimensional, deterministic signal with abrupt structural
  changes at certain points, and \eqn{\epsilon_t} is white noise. We denote by
  \eqn{r_1, r_2, ..., r_N} the elements in \code{cpt} and by \eqn{r_0 = 0} and
  \eqn{r_{N+1} = T}. Depending on the value that has been passed to \code{type}, the returned
  value is calculated as follows.

  \itemize{
  \item {For \code{type = ``mean''}, in each segment \eqn{(r_j + 1, r_{j+1})}, \eqn{f_t} for
  \eqn{t \in (r_j + 1, r_{j+1})} is approximated by the mean of \eqn{X_t} calculated
  over \eqn{t \in (r_j + 1, r_{j+1})}.}

  \item {For \code{type = ``slope''}, \eqn{f_t} is approximated by the linear spline fit with
  knots at \eqn{r_1, r_2, ..., r_N} minimising the \eqn{l_2} distance between the fit and the data.}
  }
}
\examples{
single.cpt.pcm <- c(rep(4,1000),rep(0,1000))
single.cpt.pcm.noise <- single.cpt.pcm + rnorm(2000)
cpt.single.pcm <- ID_pcm(single.cpt.pcm.noise)
fit.cpt.single.pcm <- est_signal(single.cpt.pcm.noise, cpt.single.pcm$cpt, type = "mean")

three.cpt.pcm <- c(rep(4,500),rep(0,500),rep(-4,500),rep(1,500))
three.cpt.pcm.noise <- three.cpt.pcm + rnorm(2000)
cpt.three.pcm <- ID_pcm(three.cpt.pcm.noise)
fit.cpt.three.pcm <- est_signal(three.cpt.pcm.noise, cpt.three.pcm$pcm, type = "mean")

single.cpt.plm <- c(seq(0,999,1),seq(998.5,499,-0.5))
single.cpt.plm.noise <- single.cpt.plm + rnorm(2000)
cpt.single.plm <- ID_cplm(single.cpt.plm.noise)
fit.cpt.single.plm <- est_signal(single.cpt.plm.noise, cpt.single.plm$cpt, type = "slope")
}
\author{
Andreas Anastasiou, \email{a.anastasiou@lse.ac.uk}
}
