% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICV.R
\name{ISE_mixnorm}
\alias{ISE_mixnorm}
\title{The ISE function in the case when the underlying density is the specified mixture of normal distributions.}
\usage{
ISE_mixnorm(h, x, w, mu, sdev)
}
\arguments{
\item{h}{numerical vector of bandwidth values,}

\item{x}{numerical vector of data,}

\item{w}{vector of weighs (positive numbers between 0 and 1 that add up to one),}

\item{mu}{vector of means,}

\item{sdev}{vector of standard deviations.}
}
\value{
The vector of ISE values corresponding to the specifies values of \eqn{h}.
}
\description{
Computing \eqn{ISE(h)} for given \eqn{h} in the case when the underlying density is the specified mixture of normal distributions and the Gaussian kernel is used to compute the ultimate density estimate.
}
\details{
Computing \eqn{ISE(h)} in the case when the true density is the mixture of normal distributions defined by the vector of weights \eqn{w}, the vector of means \eqn{\mu}, and the vector of standard deviations \eqn{\sigma}. See expression (2.3) of Marron and Wand (1992). It is assumed that the normals are defined as parsimonious as possible. The normal distributions in the mixture should be ordered such that the means in \eqn{\mu} are arranged in a nondecreasing order. The Gaussian kernel is to be used for computing the ultimate density estimate.
}
\examples{
\dontrun{
harg=seq(0.01,1,len=100)
w=c(3/4,1/4)
mu=c(0,3/2)
sdev=c(1,1/3)
# The vectors w, mu, and sdev define the skewed bimodal density of Marron and Wand (1992).
dat=mixnorm(300,w,mu,sdev)
h_ISE=round(h_isemixnorm(dat,w,mu,sdev),digits=4)
ISEarray=ISE_mixnorm(harg,dat,w,mu,sdev)
dev.new()
plot(harg,ISEarray,'l',lwd=3,xlab="h, n=300",ylab="ISE",cex.lab=1.7,cex.axis=1.7,main="")
title(main="ISE(h)",cex.main=1.7)
legend(0.2,0.08,legend=paste("h_ISE=",h_ISE),cex=2)
}
}
\references{
Marron, J.S., Wand, M.P. (1992). Exact Mean Integrated Squared Error. \emph{The Annals of Statistics}, 20(2), 712-736.
}
\seealso{
\code{\link{mixnorm}}, \code{\link{h_isemixnorm}}, \code{\link{MISE_mixnorm}}.
}

