% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IBMPopSim-package.R
\docType{package}
\name{IBMPopSim-package}
\alias{IBMPopSim}
\alias{IBMPopSim-package}
\title{IBMPopSim: Individual Based Model Population Simulation}
\description{
Simulation of the random evolution of heterogeneous populations using stochastic Individual-Based Models (IBMs) \doi{10.48550/arXiv.2303.06183}. The package enables users to simulate population evolution, in which individuals are characterized by their age and some characteristics, and the population is modified by different types of events, including births/arrivals, death/exit events, or changes of characteristics. The frequency at which an event can occur to an individual can depend on their age and characteristics, but also on the characteristics of other individuals (interactions). Such models have a wide range of applications. For instance, IBMs can be used for simulating the evolution of a heterogeneous insurance portfolio with selection or for validating mortality forecasts. This package overcomes the limitations of time-consuming IBMs simulations by implementing new efficient algorithms based on thinning methods, which are compiled using the 'Rcpp' package while providing a user-friendly interface.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/DaphneGiorgi/IBMPopSim}
  \item \url{https://DaphneGiorgi.github.io/IBMPopSim/}
  \item Report bugs at \url{https://github.com/DaphneGiorgi/IBMPopSim/issues}
}

}
\author{
\strong{Maintainer}: Daphné Giorgi \email{daphne.giorgi@sorbonne-universite.fr}

Authors:
\itemize{
  \item Sarah Kaakai \email{sarah.kaakai@univ-lemans.fr}
  \item Vincent Lemaire \email{vincent.lemaire@sorbonne-universite.fr}
}

}
