% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append_section_to_ini.R
\name{append_section_to_ini}
\alias{append_section_to_ini}
\title{Append section to ini file}
\usage{
append_section_to_ini(ini_file, new_section)
}
\arguments{
\item{ini_file}{file location of config.ini file}

\item{new_section}{named list of the section list}
}
\value{
No return value. Edits and overwrites input config.ini file.
}
\description{
Takes a new section in ini format and adds to existing ini.
}
\details{
The new_section must be a named list of the section list. See examples.
}
\examples{
#list of key-value pairs
CHRACC <- list(dir='/chrAcc_peaks/',
               peaks='/chrAcc_peaks/GM12878_genrich.narrowPeak')

#list of section, resulting in list of list.
new_section <- list(CHRACC=CHRACC)

#write ini
ini_file <- system.file("extdata", "config.ini")
append_section_to_ini(ini_file, new_section)

}
\author{
Tyler Hansen
}
