% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/had_goethals_Turyn.R
\name{had_goethals_Turyn}
\alias{had_goethals_Turyn}
\title{had_goethals_Turyn}
\source{
The Base sequences were obtained from
\href{http://www.math.ntua.gr/~ckoukouv/}{Christos Koukouvinos}
}
\usage{
had_goethals_Turyn(r)
}
\arguments{
\item{r}{integer (order of the matrix)}
}
\value{
Hadamard matrix of order r
}
\description{
had_goethals_Turyn performs the Hadamard Matrix from Goethals-Seidel method
by using Turyn sequences.
}
\details{
This function construct Hadamard matrix of given order using Turyn sequences.
If Turyn sequences of length 2n-1, 2n-1, n, n is available then Turyn sequences are
converted in T sequences of length 2n+p, 2n+p, 2n+p, 2n+p and p=n-1, these T sequences are used for
construction of  Hadamard matrix.
If the given order of the the Turyn sequences are not available it returns NULL.

Turyn type-sequences are available for 28,30,34,36 in the internal dataset.
}
\examples{
\donttest{
#Big matrices
had_goethals_Turyn(356)
had_goethals_Turyn(404)
}
}
\references{
Goethals, J. M. and Seidel, J. J. (1967). Orthogonal matrices with zero diagnol. Canad. J. Math., 19, 259-264.
}
