% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/had_williamson.R
\name{had_williamson}
\alias{had_williamson}
\title{had_williamson}
\source{
The williamson sequences are available in London(2013) and
\href{http://www.math.ntua.gr/~ckoukouv/}{Christos Koukouvinos}
}
\usage{
had_williamson(x)
}
\arguments{
\item{x}{integer (order of the matrix)}
}
\value{
Hadamard matrix
}
\description{
had_williamson performs the construction Hadamard matrix from Williamson method by using the
williamson sequences.
}
\details{
This function construct Hadamard matrix of given order using williamson sequences.
If Williamson sequences of length n,n,n,n are available, Hadamard matrix of order 4n can be constructed.
If for given order of Matrix Williamson sequences are not available it retuns NULL.

The  Williamson sequences are stored in internal dataset,
available for length of seq(1,63, 2) except 15, 35, 47, 53, 59 in the internal table.
}
\examples{
had_williamson(4)
#      [,1] [,2] [,3] [,4]
#[1,]    1    1    1    1
#[2,]   -1    1   -1    1
#[3,]   -1    1    1   -1
#[4,]   -1   -1    1    1
had_williamson(8)
# NULL
}
\references{
Williamson, J. (1944). Hadamard determinant theorem and the sum of four squares. Duke. Math. J., 11, 65-81.

Williamson, J. (1947). Note on Hadamard's determnant theorem. Bull. Amer. Math. Soc., 53, 608-613.

London, S. 2013. Constructing New Turyn Type Sequences, T-Sequences and Hadamard Matrices. PhD Thesis, University of Illinois at Chicago, Chicago.
}
