% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_coverage_heatmap.R
\name{plot_coverage_heatmap}
\alias{plot_coverage_heatmap}
\title{Coverage heatmap}
\usage{
plot_coverage_heatmap(
  x_dat,
  protein = x_dat[["Protein"]][1],
  state = NULL,
  value = NULL,
  time_t = NULL,
  interactive = getOption("hadex_use_interactive_plots")
)
}
\arguments{
\item{x_dat}{data created using calculate_ or create_ 
function}

\item{protein}{selected protein}

\item{state}{selected biological state}

\item{value}{value to be presented}

\item{time_t}{chosen time point}

\item{interactive}{\code{logical}, whether plot should have an interactive 
layer created with with ggiraph, which would add tooltips to the plot in an
interactive display (HTML/Markdown documents or shiny app)}
}
\value{
a \code{\link[ggplot2]{ggplot}} object
}
\description{
Coverage heatmap with color indicating
specific value
}
\details{
Plots standard protein coverage but colored with 
desired value.
}
\examples{
uptake_dat <- create_uptake_dataset(alpha_dat, states = "Alpha_KSCN")
plot_coverage_heatmap(uptake_dat)
plot_coverage_heatmap(x_dat = uptake_dat, value = "frac_deut_uptake", time_t = 0.167)
plot_coverage_heatmap(uptake_dat, value = "err_frac_deut_uptake", time_t = 0.167)

diff_uptake_dat <- create_diff_uptake_dataset(alpha_dat)
plot_coverage_heatmap(diff_uptake_dat)
plot_coverage_heatmap(diff_uptake_dat, value = "diff_frac_deut_uptake")
plot_coverage_heatmap(diff_uptake_dat, value = "diff_frac_deut_uptake", time_t = 0.167)
plot_coverage_heatmap(diff_uptake_dat, value = "err_diff_frac_deut_uptake", time_t = 0.167)

auc_dat <- calculate_auc(create_uptake_dataset(alpha_dat))
plot_coverage_heatmap(auc_dat, value = "auc")

bex_dat <- calculate_back_exchange(alpha_dat, state = "Alpha_KSCN")
plot_coverage_heatmap(bex_dat, value = "back_exchange")

}
\seealso{
\code{\link{read_hdx}}
\code{\link{plot_coverage}}
}
