% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HTGM.R
\name{HTGM}
\alias{HTGM}
\title{HTGM}
\usage{
HTGM(
  title = NULL,
  dir = tempdir(),
  sampleLists,
  GOGOA3,
  ONT,
  enrichThresh = 2,
  countThresh = 5,
  fdrThresh = 0.1,
  nrand = 100,
  mn = 2,
  mx = 200,
  opt = 0,
  verbose = 1
)
}
\arguments{
\item{title}{character string descriptive title}

\item{dir}{character string full pathname to the directory acting as result repository}

\item{sampleLists}{list of character vector of user-supplied genes of interest}

\item{GOGOA3}{return value of subsetGOGOA()}

\item{ONT}{c("molecular_function","cellular_component","biological_process")}

\item{enrichThresh}{numerical acceptance threshold for enrichment passed to GoMiner}

\item{countThresh}{numerical acceptance threshold for gene count passed to GoMiner}

\item{fdrThresh}{numerical acceptance threshold for fdr passed to GoMiner}

\item{nrand}{integer number of randomizations passed to GoMiner}

\item{mn}{integer param passed to trimGOGOA3, min size threshold for a category}

\item{mx}{integer param passed to trimGOGOA3, max size threshold for a category}

\item{opt}{integer 0:1 parameter used to select randomization method}

\item{verbose}{integer parameter passed to vprint()}
}
\value{
returns the matrix of significant categories versus study
}
\description{
driver to invoke GoMiner for multiple studies, and integrate the results
in a categories versus study hyperlinked heatmap
}
\examples{
\dontrun{
# GOGOA3.RData is too large to include in the R package
# so I need to load it from a file that is not in the package.
# Since this is in a file in my own file system, I could not
# include this as a regular example in the package.
# you can generate it using the package 'minimalistGODB'
# or you can retrieve it from https://github.com/barryzee/GO/tree/main/databases
load("/Users/barryzeeberg/personal/GODB_RDATA/goa_human/GOGOA3_goa_human.RData")

# load("data/Housekeeping_Genes.RData")
sampleList<-unique(as.matrix(Housekeeping_Genes[,"Gene.name"]))
n<-nrow(sampleList)
sampleLists<-list()
# test the effect of random sampling of the entire gene set
# this can give an idea of the quality of the GoMiner results
# when the complete gene set is yet to be determined
sampleLists[["1"]]<-sampleList[sample(n,n/2)]
sampleLists[["2"]]<-sampleList[sample(n,n/2)]
sampleLists[["3"]]<-sampleList[sample(n,n/2)]
sampleLists[["4"]]<-sampleList[sample(n,n/2)]
sampleLists[["5"]]<-sampleList[sample(n,n/2)]
sampleLists[["ALL"]]<-sampleList
m<-HTGM(title=NULL,dir=tempdir(),sampleLists,GOGOA3,ONT="biological_process",
 enrichThresh=2,countThresh=5,fdrThresh=0.10,nrand=100)
}

}
