% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_oracle_infer.R
\name{get_oracle_bias_var_adj2c}
\alias{get_oracle_bias_var_adj2c}
\title{Estimate the oracle bias, the exact variance and approximated variance of the debiased estimator tau_adj2c inspired by HOIF (Zhao et al.(2024)).}
\usage{
get_oracle_bias_var_adj2c(X, Y1, n1 = NULL)
}
\arguments{
\item{X}{The n by p covariates matrix.}

\item{Y1}{Vector of n dimensional potential response Y(1).}

\item{n1}{The number of subjects in the treatment group.}
}
\value{
A list of oracle bias and variance of the debised adjusted estimator tau_adj2c.
\item{bias_adj2c}{The oracle bias of the debiased estimator tau_adj2c.}
\item{variance_exact_adj2c}{The oracle exact bias of the debiased estimator tau_adj2c.}
\item{variance_approx_adj2c}{The oracle approximated variance of the debiased estimator tau_adj2c which omits the term of order o(1/n).}
\item{variance_unadj}{The oracle variance of the unadjusted estimator.}
}
\description{
Estimate the oracle bias, the exact variance and approximated variance of the debiased estimator tau_adj2c inspired by HOIF (Zhao et al.(2024)).
}
\examples{
NULL
}
\references{
Zhao, S., Wang, X., Liu, L., & Zhang, X. (2024). Covariate adjustment in randomized experiments motivated by higher-order influence functions. arXiv preprint. https://arxiv.org/abs/2411.08491.
}
