% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{extract_design}
\alias{extract_design}
\title{Extracting covariance matrices from lme}
\usage{
extract_design(b)
}
\arguments{
\item{b}{a fitted model object of class \code{lme}.}
}
\value{
A list of matrices is returned.
\itemize{
\item{\code{D} contains the covariance matrix of the random effects.}
\item{\code{V} contains the covariance matrix of the response.}
\item{\code{X} contains the fixed-effect model matrix.}
\item{\code{Z} contains the random-effect model matrix.}}
}
\description{
This function extracts the full covariance matrices from a mixed/hierarchical
linear model fit using \code{lme}.
}
\references{
This method has been adapted from the method
  \code{mgcv::extract.lme.cov} in the \code{mgcv} package, written by Simon
  N. Wood \email{simon.wood@r-project.org}.
}
\author{
Adam Loy \email{loyad01@gmail.com}
}
