% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLStoUNI.R
\name{validateGLstring}
\alias{validateGLstring}
\title{Validate a GL String}
\usage{
validateGLstring(GLstring, version)
}
\arguments{
\item{GLstring}{A character string of allele names and operators in the GL String format.}

\item{version}{A character string identifying the GL String version for evaluation. Options are "1.0" and "1.1".}
}
\value{
A logical. TRUE is returned when all characters in a 'version' GL String are permitted. FALSE is returned when forbidden characters are present, or when an incorrect 'version' is specified.
}
\description{
Evaluates a GL String to identify unsupported characters for a specified GL String version.
}
\examples{
validateGLstring("HLA-A*02:01/HLA-A*02:02+HLA-A*03:01/HLA-A*03:02", version = "1.0")

}
\references{
Mack et al. HLA 2023;102(2):206-212 https://doi.org/10.1111/tan.15126
}
