% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareSequences.R
\name{compareSequences}
\alias{compareSequences}
\title{Identify Sequence Differences Between Two Alleles at a Locus}
\usage{
compareSequences(alignType, alleles)
}
\arguments{
\item{alignType}{A character string identifying the type of alignment being searched. Allowed values are "codon","gen", nuc" and "prot". Only one 'alignType' value is permitted.}

\item{alleles}{A character vector containing two full-length names for alleles at the same locus.}
}
\value{
A two-row data frame identifying the positions and sequences at which the two alleles differ. E.g., compareSequences(alignType = "gen", alleles = c("DPA1\*01:03:38:01","DPA1\*01:03:38:02"). Positions for which the sequence of either allele is unknown are ignored.
}
\description{
Compares the sequences of two alleles at a locus, and identifies the differences between them at specific positions
}
