% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlasFull.R
\name{atlasFull}
\alias{atlasFull}
\title{Generate a Complete set of Protein, Coding nucleotide and Genomic Nucleotide Atlases}
\usage{
atlasFull(version = "Latest")
}
\arguments{
\item{version}{A character string identifying the version of the ANHIG/IMGTHLA Github repository used to generate atlases. The default value, "Latest", generates an atlas for the most recent IPD-IMGT/HLA Database release.}
}
\value{
A list object containing a list of data frames of protein (prot), coding nucleotide (nuc), and genomic nucleotide (gen) atlases for all genes in the IPD-IMGT/HLA Database release, along with a character vector identifying the pertinent IPD-IMGT/HLA Database release.
}
\description{
Applies atlasMaker() to build a set of 'atlases' identifying the gene-feature (exon, intron, and UTR) boundaries in the protein, coding nucleotide, and genomic nucleotide alignments of all HLA loci.
}
\note{
Data informing the atlases were downloaded from the ANHIG/IMGTHLA Github repository.

For internal HLAtools use.
}
