% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/av_timepoint_proc_plots.R
\name{plots_av_tp_proc}
\alias{plots_av_tp_proc}
\title{Returns average procent deuteration plot for time points}
\usage{
plots_av_tp_proc(df, replicates = 3, cola)
}
\arguments{
\item{df}{output from functions output_tp_proc.}

\item{replicates}{number of replicates in set as default set to 3.}

\item{cola}{color pallette for different Protein States. As default Paired pallette from RColorBrewer is used.}
}
\value{
average deuteration plots
}
\description{
Returns plots with average procent deuteration at each peptide.
}
\examples{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
a<- output_tp(file_nm, percent=TRUE)
plots_av_tp_proc(df=a, replicates=3, cola=c(1:4))
plots_av_tp_proc(df=a)
}
