% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDSpatialScan_plotSummary.R
\name{plotSummary.ResScanOutputUniFunct}
\alias{plotSummary.ResScanOutputUniFunct}
\title{Plots the mean or median curves in the clusters detected by a univariate functional scan procedure (PFSS, NPFSS, DFFSS or URBFSS)}
\usage{
\method{plotSummary}{ResScanOutputUniFunct}(x, type = "mean", colors = "red", only.MLC = FALSE, ...)
}
\arguments{
\item{x}{ResScanOutputUniFunct. Output of a univariate functional scan function (PFSS, NPFSS, DFFSS or URBFSS).}

\item{type}{character. "mean" or "median". If "mean": the mean curves in the clusters are plotted in solid lines, outside the cluster in dots, the global mean curve is in black. If "median": the median curves in the clusters are plotted in solid lines, outside the cluster in dots, the global median curve is in black.}

\item{colors}{character. The colors to plot the clusters' summary curves. If length(colors)==1 then all the clusters will be plotted in this color. Else there must be the same number of elements in colors than the number of clusters}

\item{only.MLC}{logical. Should we plot only the MLC or all the significant clusters?}

\item{...}{Further arguments to be passed to or from methods.}
}
\value{
No value returned, plots the curves.
}
\description{
This function plots the mean or median curves in the clusters detected by a univariate functional scan procedure (PFSS, NPFSS, DFFSS or URBFSS).
}
\examples{
\donttest{
library(sp)
data("map_sites")
data("funi_data")
coords <- coordinates(map_sites)

res_npfss <- SpatialScan(method = "NPFSS", data = funi_data, sites_coord = coords,
system = "WGS84", mini = 1, maxi = nrow(coords)/2)$NPFSS

plotSummary(x = res_npfss, type = "median")}
\dontshow{
library(sp)
data("map_sites")
data("funi_data")
indices <- c(51:75)
coords <- coordinates(map_sites[indices,])
res_npfss <- SpatialScan(method = "NPFSS", data = funi_data[indices,],
sites_coord = coords,
system = "WGS84", mini = 1, maxi = nrow(coords)/2, MC = 99)$NPFSS
if(length(res_npfss$sites_clusters)>0){
plotSummary(x = res_npfss, type = "mean")
}

}

}
