% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inspect.R
\name{Inspect_test}
\alias{Inspect_test}
\title{Inspect single change-point test}
\usage{
Inspect_test(
  X,
  lambda = NULL,
  xi = NULL,
  eps = 1e-10,
  empirical = FALSE,
  N = 100,
  tol = 1/100,
  maxiter = 10000,
  rescale_variance = TRUE,
  debug = FALSE
)
}
\arguments{
\item{X}{Matrix of observations, where each row contains a time series}

\item{lambda}{Manually specified value of \eqn{\lambda} (can be \code{NULL}, in which case \eqn{\lambda \gets \sqrt{\log(p\log n)/2}})}

\item{xi}{Manually specified value of \eqn{\xi} (can be NULL, in which case \eqn{\xi \gets 4\sqrt{\log(np)}})}

\item{eps}{Threshold for declaring numerical convergence of the power method}

\item{empirical}{If \code{TRUE}, the detection threshold \eqn{xi} is based on Monte Carlo simulation using \code{\link{Inspect_test_calibrate}}}

\item{N}{If \code{empirical=TRUE}, \code{N} is the number of Monte Carlo samples used}

\item{tol}{If \code{empirical=TRUE}, \code{tol} is the false error probability tolerance}

\item{maxiter}{Maximum number of iterations for the power method}

\item{rescale_variance}{If \code{TRUE}, each row of the data is re-scaled by a MAD estimate using \code{\link{rescale_variance}}}

\item{debug}{If \code{TRUE}, diagnostic prints are provided during execution}
}
\value{
1 if a change-point is detected, 0 otherwise
}
\description{
R wrapper for C function testing for a single change-point using Inspect \insertCite{wang_high_2018;textual}{HDCD}.
}
\examples{
library(HDCD)
n = 50
p = 50

# Generating data
X = matrix(rnorm(n*p), ncol = n, nrow=p)
Y = matrix(rnorm(n*p), ncol = n, nrow=p)

# Adding a single sparse change-point to X (and not Y):
X[1:5, 26:n] = X[1:5, 26:n] +1

# Vanilla Inspect:
resX = Inspect_test(X)
resX
resY = Inspect_test(Y)
resY

# Manually setting \lambda and \xi:
resX = Inspect_test(X, 
                    lambda = sqrt(log(p*log(n))/2),
                    xi = 4*sqrt(log(n*p))
)
resX 
resY = Inspect_test(Y, 
                    lambda = sqrt(log(p*log(n))/2),
                    xi = 4*sqrt(log(n*p))
)
resY

# Empirical choice of thresholds:
resX = Inspect_test(X, empirical = TRUE, N = 100, tol = 1/100)
resX
resY = Inspect_test(Y, empirical = TRUE, N = 100, tol = 1/100)
resY

# Manual empirical choice of thresholds (equivalent to the above)
thresholds_test_emp = Inspect_test_calibrate(n,p, N=100, tol=1/100)
resX = Inspect_test(X, xi = thresholds_test_emp$max_value)
resX
resY = Inspect_test(Y, xi = thresholds_test_emp$max_value)
resY
}
\references{
\insertAllCited{}
}
