% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CUSUM.R
\name{CUSUM}
\alias{CUSUM}
\title{CUSUM transformation of a matrix}
\usage{
CUSUM(X, start = NULL, stop = NULL)
}
\arguments{
\item{X}{Matrix of observations, where each row contains a time series}

\item{start}{Starting point of interval over which the CUSUM should be computed, subtracted by one}

\item{stop}{Ending point of interval over which the CUSUM should be computed, subtracted by one}
}
\value{
A matrix of CUSUM values. The \eqn{(i,j)}-th element corresponds to the CUSUM transformation of the \eqn{i}-th row of \eqn{X}, computed over the interval \eqn{(\code{start}+1,\code{end}+1]} and evaluated at position \eqn{\code{start}+1+j}, i.e. 
\eqn{\sqrt{\frac{e-v}{(e-s)(v-s)}}\sum_{t=s+1}^v X_{i,t} - \sqrt{\frac{v-s}{(e-s)(e-v)}}\sum_{t=v+1}^e X_{i,t}}, 
where \eqn{s = (\code{start}+1)}, \eqn{e = (\code{stop}+1)} and \eqn{v = \code{start}+1+j}.
}
\description{
R wrapper for C function computing the CUSUM transformation of a matrix over an interval \eqn{(s,e]}. For compatibility with C indexing, the user should subtract \eqn{1} from both \eqn{s} and \eqn{e} when supplying the arguments to the function. If start and stop are not supplied, the CUSUM is computed over the full data, so \eqn{(s,e] = (0,n]}. In this case, \code{CUSUM} returns the same result as \code{cusum.transform} in the package \code{InspectChangepoint} \insertCite{inspectpackage}{HDCD}.
}
\examples{
n = 10
p = 10
set.seed(101)
X = matrix(rnorm(n*p), ncol = n, nrow=p)
# CUSUM over the full data (s,e] = (0,n]
X_cusum = CUSUM(X)

# CUSUM over (s,e] = (3,9]:
s = 3
e = 9
X_cusum = CUSUM(X, start = s-1, stop = e-1)
}
\references{
\insertAllCited{}
}
