% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_ccsr.R
\name{read_ccsr}
\alias{read_ccsr}
\title{Read CCSR Mapping Files from Disk}
\usage{
read_ccsr(
  file_path = NULL,
  type = NULL,
  version = "latest",
  clean_names = TRUE,
  as_data_table = NULL,
  name = NULL
)
}
\arguments{
\item{file_path}{Optional character string, path to a CCSR mapping file. Can be:
\itemize{
\item A ZIP file path (will be extracted and read)
\item A CSV/Excel file path (will be read directly)
\item A directory path containing extracted CCSR files
If NULL (default), automatically searches the cache directory for files
downloaded via \code{download_ccsr()}.
}}

\item{type}{Character string specifying the type of CCSR file. Must be one
of: "diagnosis" (or "dx") for ICD-10-CM diagnosis codes, or "procedure"
(or "pr") for ICD-10-PCS procedure codes. If NULL and \code{file_path} is NULL,
defaults to "diagnosis". If \code{file_path} is provided, the function will
attempt to infer the type from the file name or contents.}

\item{version}{Character string specifying the CCSR version to read from cache.
Use "latest" (default) to read the most recent version, or specify a version
like "v2026.1", "v2025.1", etc. Only used when \code{file_path} is NULL.}

\item{clean_names}{Logical. If TRUE (default), column names are cleaned to
follow R naming conventions (snake_case).}

\item{as_data_table}{Logical or NULL. If TRUE and the \code{data.table} package is
available, returns a \code{data.table} object instead of a tibble. If FALSE,
returns a tibble. If NULL (default), prompts the user interactively to
choose (only in interactive sessions). In non-interactive sessions, defaults
to FALSE. Note: tibbles are already data frames and work with all standard
R data frame operations.}

\item{name}{Optional character string, suggested variable name for the
returned data. This is only used for display/messaging purposes and does
not automatically assign the data to a variable. You must still assign the
result: \code{my_data <- read_ccsr()}. If NULL (default), a name is suggested
based on the file type and version.}
}
\value{
A tibble (or data.table if \code{as_data_table = TRUE}) containing the
CCSR mapping data. Tibbles are data frames and can be used with all
standard R data frame operations, including \code{dplyr}, \code{data.table}, and
base R functions.
}
\description{
Reads previously downloaded CCSR mapping files from disk. If no file path is
provided, automatically finds and reads cached files from \code{download_ccsr()}.
}
\details{
This function can read CCSR files in several formats:
\itemize{
\item ZIP files downloaded from HCUP (will extract and read the CSV/Excel file)
\item CSV files (extracted from ZIP or saved separately)
\item Excel files (if \code{readxl} package is available)
\item Directories containing extracted files
\item Cached files from \code{download_ccsr()} (automatic if \code{file_path} is NULL)
}

The function automatically detects the file format and handles encoding
issues, preserving leading zeros in ICD-10 codes.

When \code{file_path} is NULL, the function automatically searches the cache
directory (\verb{tempdir()/HCUPtools_cache/}) for files matching the specified
\code{type} and \code{version}. This makes it easy to read previously downloaded
files without needing to know the exact file path.
}
\note{
To use the data, assign it to a variable:
\code{my_data <- read_ccsr()}. The \code{name} parameter is only for display
purposes and does not automatically assign the data.
}
\examples{
\donttest{
# Automatically read latest cached diagnosis file
# Assign to a variable to use the data
dx_map <- read_ccsr()

# Read specific version from cache with suggested name
dx_map_v2025 <- read_ccsr(type = "diagnosis", version = "v2025.1", name = "dx_map_v2025")

# Read procedure file from cache
pr_map <- read_ccsr(type = "procedure")

# Read from a specific file path (manual)
dx_map <- read_ccsr("path/to/DXCCSR-v2026-1.zip")

# Read from a CSV file
dx_map <- read_ccsr("path/to/DXCCSR_v2026_1.csv")

# Read from a directory
dx_map <- read_ccsr("path/to/extracted_ccsr_files/")

# Use the data after assignment
head(dx_map)
nrow(dx_map)
}

}
