% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{RISE}
\alias{RISE}
\title{Rank-based Two-Sample Tests on Similarity / Graph-Induced Rank Matrices}
\usage{
RISE(
  X = NULL,
  Y = NULL,
  S = NULL,
  sample1ID = NULL,
  sample2ID = NULL,
  k = 10,
  rank.type = "RgNN",
  perm = 0
)
}
\arguments{
\item{X}{Numeric matrix of size \eqn{m \times p} (first sample).
Optional if \code{S} is supplied.}

\item{Y}{Numeric matrix of size \eqn{n \times p} (second sample).
Optional if \code{S} is supplied.}

\item{S}{Numeric similarity matrix of size \eqn{N \times N} with \eqn{N=m+n}
(larger values indicate greater similarity). If \code{X} and \code{Y} are provided,
\code{S} is constructed internally as \code{-dist(rbind(X, Y))}.}

\item{sample1ID}{Integer indices (length \eqn{m}) for sample \eqn{X} in \code{S}.
Ignored if \code{X} and \code{Y} are given.}

\item{sample2ID}{Integer indices (length \eqn{n}) for sample \eqn{Y} in \code{S}.
Ignored if \code{X} and \code{Y} are given.}

\item{k}{Positive integer tuning parameter.
For \code{"RgNN"}/\code{"RoNN"}, it is the neighborhood size in the k-nearest-neighbor graph (k-NNG);
for \code{"RgMST"}/\code{"RoMST"}, it controls the number of minimum-spanning-tree layers (k-MST);
for \code{"RoMDP"}, it specifies the number of rounds of minimum-distance non-bipartite matching (k-MDP).}

\item{rank.type}{Character, one of \code{c("RgNN","RoNN","RgMST","RoMST","RoMDP")}.
Prefix \code{"Rg"} denotes graph-induced ranks; prefix \code{"Ro"}
denotes overall ranks obtained by ordering all selected edges. See the references for precise definitions.}

\item{perm}{Integer, number of permutations for a permutation p-value (default \code{0}).}
}
\value{
A list with components:
\itemize{
\item \code{test.statistic}: quadratic form \eqn{T_R}.
\item \code{pval.approx}: asymptotic p-value (chi-square, df = 2).
\item \code{pval.perm}: permutation p-value (present only if \code{perm > 0}).
}
}
\description{
\code{RISE} constructs a nonnegative, symmetric rank/graph matrix \eqn{R} from
two samples \eqn{X} and \eqn{Y} (or from a pre-computed similarity matrix \eqn{S}),
then computes a Hotelling-type quadratic statistic with an asymptotic
chi-square p-value. Optionally, a permutation p-value is returned.
}
\details{
From \eqn{S} (or from \eqn{X}, \eqn{Y}), the procedure constructs a
symmetric matrix \eqn{R} with zero diagonal using one of the supported
graph/ranking schemes. It then forms the within-group edge sums
\eqn{U_x = \sum_{i,j \in X} R_{ij}} and
\eqn{U_y = \sum_{i,j \in Y} R_{ij}}.
The expectation vector and covariance matrix of \eqn{(U_x, U_y)} are
derived under the permutation null distribution. The test statistic is
\deqn{T = ( U_x - \mu_x, U_y - \mu_y ) \Sigma^{-1}
       \begin{pmatrix} U_x - \mu_x \\ U_y - \mu_y \end{pmatrix},}
where \eqn{\mu_x, \mu_y} are the expected values and \eqn{\Sigma} is the
covariance matrix. Under the null hypothesis, \eqn{T} is asymptotically
chi-square distributed with 2 degrees of freedom.
}
\examples{
set.seed(1)
X <- matrix(rnorm(50*100, mean = 0), nrow=50)
Y <- matrix(rnorm(50*100, mean = 0.3), nrow=50)
# RgNN: graph-induced ranks from the k-nearest-neighbor graph
out.RgNN <- RISE(X = X, Y = Y, k = 10, rank.type = "RgNN", perm = 1000)
out.RgNN

# RoNN: overall ranks obtained by ordering edges from the k-NN graph
out.RoNN <- RISE(X = X, Y = Y, k = 10, rank.type = "RoNN", perm = 1000)
out.RoNN

# RgMST: graph-induced ranks from layered minimum spanning trees
\donttest{
out.RgMST <- RISE(X = X, Y = Y, k = 10, rank.type = "RgMST", perm = 1000)
out.RgMST
}

# RoMST: overall ranks obtained by ordering edges in the MST
\donttest{
out.RoMST <- RISE(X = X, Y = Y, k = 10, rank.type = "RoMST", perm = 1000)
out.RoMST
}

# RoMDP: overall ranks obtained by ordering edges from minimum-distance pairings
\donttest{
out.RoMDP <- RISE(X = X, Y = Y, k = 10, rank.type = "RoMDP", perm = 1000)
out.RoMDP
}

}
\references{
Zhou, D. and Chen, H. (2023).
\emph{A new ranking scheme for modern data and its application to two-sample hypothesis testing}.
In \emph{Proceedings of the 36th Annual Conference on Learning Theory (COLT 2023)}, PMLR, pp. 3615–3668.
}
\seealso{
\code{\link{rTests.base}}, \code{\link{Cov.asy}}
}
