% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FA.R
\name{est_num}
\alias{est_num}
\title{Estimate Factor Numbers}
\usage{
est_num(X, kmax = 8, type = "BIC3")
}
\arguments{
\item{X}{The observation data matrix of dimension \eqn{T \times N}.}

\item{kmax}{The maximum number of factors to consider. Default is 8.}

\item{type}{The criterion used in determining the number of factors. Default is \code{"BIC3"}.
Options: \code{"PC1"}, \code{"PC2"}, \code{"PC3"}, \code{"IC1"}, \code{"IC2"}, \code{"IC3"},
\code{"AIC3"}, \code{"BIC3"}, \code{"ER"}, \code{"GR"}.}
}
\value{
\item{rhat}{The estimated number of factors (an integer).}
}
\description{
Estimates the number of factors using various Information Criteria (IC) and Eigenvalue Ratio tests.
}
\examples{
\dontrun{
X <- matrix(rnorm(100*20), 100, 20)
est_num(X, kmax = 8, type = "BIC3")
est_num(X, kmax = 8, type = "ER")
}
}
\references{
Bai, J., & Ng, S. (2002). Determining the number of factors in approximate factor models. Econometrica, 70(1), 191-221.

Ahn, S. C., & Horenstein, A. R. (2013). Eigenvalue ratio test for the number of factors. Econometrica, 81(3), 1203-1227.
}
