% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PEE_SingleTaxon.R
\name{PEE_SingleTaxon}
\alias{PEE_SingleTaxon}
\title{Function to calculate PEE [1] matrices for all the geographic range measures}
\usage{
PEE_SingleTaxon(GeoRare, TName = "Brach 1")
}
\arguments{
\item{GeoRare}{- The list of geographic range measures calculated from the GeoRarefaction_SingleTaxon or GeoRarefaction_MultiTaxa functions}

\item{TName}{- Name of the target taxon for analysis as a string}
}
\value{
Returns a list of six geographic range measures matrix with percent error of estimates for each value
}
\description{
Function to calculate PEE [1] matrices for all the geographic range measures
}
\examples{
\dontrun{
data(BivalvePBDB)
BivalveMatrix<-CoordList_PBDB(BivalvePBDB)
BivalveGeo<-GeoRarefaction_MultiTaxa(nLocCut=50,OccMatrix=BivalveMatrix,TaxaStart=3,iter=20)
PEE_SingleTaxon(GeoRare=BivalveGeo,TName=names(BivalveGeo)[3])
}
}
\references{
[1] Russell, M.P. & D.R. Lindberg. 1988. Real and Random Patterns Associated with Molluscan Spatial and Temporal Distributions. Paleobiology 14:322-330.
}
\seealso{
See the velociraptr package for details of the downloadPBDB() function
}
