% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeoCor.R
\name{GeoCor}
\alias{GeoCor}
\title{Function to calculate the correlation coefficient for pairwise comparisons between geographic range measures}
\usage{
GeoCor(GeoRange, Start = 1, method = "pearson")
}
\arguments{
\item{GeoRange}{- A matrix of taxa by geographic range calculations, as from the GeoRange_MultiTaxa function}

\item{Start}{- The column index value where geographic range measures to be compared starts}

\item{method}{- The correlation method to be used. See the cor() function for available inputs}
}
\value{
Returns a sparse pairwsie matrix of correlation coefficients
}
\description{
Function to calculate the correlation coefficient for pairwise comparisons between geographic range measures
}
\note{
The correlation calculation uses the "pairwise.complete.obs" option from the cor function so that only complete pairs of observations are used, pairs containing an NA are ignored
}
\examples{
\dontrun{
data(BivalvePBDB)
BivalveMatrix<-CoordList_PBDB(BivalvePBDB)
testBivalve<-GeoRange_MultiTaxa(OccMatrix=BivalveMatrix,TaxaStart=3)
GeoCor(testBivalve,Start=1,method="kendall")
}
}
\seealso{
See the velociraptr package for details of the downloadPBDB() function
}
