% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{classify_exons}
\alias{classify_exons}
\title{Classify Exons by Their Relative Transcript Position}
\usage{
classify_exons(input, verbose = TRUE)
}
\arguments{
\item{input}{A character string specifying the path to a GTF/GFF3 file or a data frame containing GTF-formatted data. The file should follow the GENCODE format conventions.}

\item{verbose}{A logical indicating whether to display progress messages and exon counts. Defaults to \code{TRUE}.}
}
\value{
A data frame identical to the input but with an additional column \code{EXON_CLASSIFICATION}. This column contains one of the following values for each exon:
\itemize{
\item \code{"single_exon"}: The transcript contains only one exon.
\item \code{"first_exon"}: The first exon in a multi-exon transcript.
\item \code{"last_exon"}: The last exon in a multi-exon transcript.
\item \code{"inner_exon"}: Exons between the first and last in multi-exon transcripts.
}
}
\description{
Categorizes each exon in a transcript as single, first, inner, or last based on its position. This classification helps in analyzing transcript structure and splicing patterns.
}
\details{
The function processes the input GTF data to:
\enumerate{
\item Load the GTF file (if a path is provided) or use the provided data frame.
\item Filter entries to include only exons.
\item For each transcript, count the total exons and determine each exon's position.
\item Classify exons based on their position and the total count.
}
If \code{verbose = TRUE}, the function prints counts of each exon type.
}
\examples{

# Example 1: Using the provided example GTF files
file_v1 <- system.file("extdata", "gencode.v1.example.gtf.gz", package = "GencoDymo2")
gtf_v1 <- classify_exons(file_v1)

# Example 2: Using a pre-loaded data frame
file_v1 <- system.file("extdata", "gencode.v1.example.gtf.gz", package = "GencoDymo2")
gtf_v1 <- load_file(file_v1)
classified_data_v1 <- classify_exons(gtf_v1)

}
