% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/introns.R
\name{assign_splice_sites}
\alias{assign_splice_sites}
\title{Assign intron donor and acceptor splice sites consensus}
\usage{
assign_splice_sites(input, genome, verbose = TRUE)
}
\arguments{
\item{input}{A data frame containing intron coordinates.}

\item{genome}{A \code{BSgenome} object like \code{BSgenome.Hsapiens.UCSC.hg38}. Must be explicitly passed.}

\item{verbose}{Logical. If TRUE, the function prints progress messages while preparing the splice site data. Default is TRUE.}
}
\value{
A data frame containing the original intron data, with two additional columns:
\itemize{
\item \code{donor_ss}: The donor splice site consensus sequence for each intron.
\item \code{acceptor_ss}: The acceptor splice site consensus sequence for each intron.
}
}
\description{
This function takes a data frame of intron coordinates and a genome sequence (ideally human or mouse) and returns a data frame with two additional columns for the donor and acceptor splice site consensus sequences.
It prepares the donor and acceptor sequences based on the provided intron coordinates and the specified genome (e.g., human hg38), making it useful for downstream analysis of splicing events.
}
\examples{
\dontrun{
  if (requireNamespace("BSgenome.Hsapiens.UCSC.hg38", quietly = TRUE)) {
    genome <- BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38
    file_v1 <- system.file("extdata", "gencode.v1.example.gtf.gz", package = "GencoDymo2")
    gtf_v1 <- load_file(file_v1)
    introns_df <- extract_introns(gtf_v1)
    result <- assign_splice_sites(introns_df, genome)
  }
}

}
\seealso{
\code{\link{extract_introns}}, \code{\link{find_cryptic_splice_sites}}
}
