#'@title Function to estimate quantiles for weigthed Brownian Motion functional
#'
#'@description Function to calculate the critical value for the Euclidean norm of  d-dimensional  BM divided by t^gamma
#'
#'@param n          number of points
#'@param d          dimension of Brownian motion
#'@param gamma      parameter between 0 and 0.5 (not included)
#'@param B          number of bootstrap samples (default 50000)
#'@param alpha      vector of probabilities (default is (.90,.95,.975,.99))
#'@param n_cores    number of cores for parallel computing (default is 2)
#'
#'@return \item{qs}{Simulated quantiles of weighted BM}
#'@export
#'
#' SimQuantilesWBM(100,3, 0.1)



SimQuantilesWBM <- function(n, d, gamma, B=50000, alpha=c(.90,.95,.975,.99), n_cores=2)
  {

  cl <- parallel::makePSOCKcluster(n_cores)
  doParallel::registerDoParallel(cl)

  fun = c('SimBM','funBM')
  result <- foreach::foreach(i=1:B, .export=fun) %dopar% funBM(n,d,gamma)
  parallel::stopCluster(cl)
  stat = rep(0,B)
  for (i in 1:B){
    stat[i] = result[[i]][1]
  }
  q = quantile(stat, alpha)
  return(q) # Critical value for the specified significance level
}
