% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chat.history.print.R
\name{chat.history.print}
\alias{chat.history.print}
\title{Chat History Print}
\usage{
chat.history.print(genai.object, from = 1, to = NULL)
}
\arguments{
\item{genai.object}{A generative AI object containing necessary and correct information.}

\item{from}{Optional. Default to 1. An integer representing the first message in the chat history that needs
to be printed.}

\item{to}{Optional. Default to \code{NULL}, prints until the last message in the chat history. An integer
representing the last message in the chat history that needs to be printed.}
}
\description{
This function prints out the chat history along with a generative AI object.
}
\details{
Providing accurate and valid information for each argument is crucial for successful chat
generation by the generative AI model. If any parameter is incorrect, the function responds with an
error message based on the API feedback. To view all supported generative AI models, use the
function \code{\link{available.models}}.
}
\examples{
\dontrun{
# Assuming there is a GenAI object named 'genai.model' supporting this
# function, please refer to the "Live Demo in Colab" above for real
# examples. The following examples are just some basic guidelines.

# Method 1 (recommended): use the pipe operator "\%>\%"
genai.model \%>\%
  chat.history.print()

# Method 2: use the reference operator "$"
genai.model$chat.history.print(from = 3)

# Method 3: use the function chat.history.print() directly
chat.history.print(genai.object = genai.model,
                   from = 3,
                   to = 5)
}

}
\seealso{
\href{https://genai.gd.edu.kg/r/documentation/}{GenAI - R Package "GenAI" Documentation}

\href{https://colab.research.google.com/github/GitData-GA/GenAI/blob/gh-pages/r/example/chat_history_print.ipynb}{Live Demo in Colab}
}
