% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn.graph.R
\name{knn.graph}
\alias{knn.graph}
\title{Saturated or K Nearest Neighbor Graph}
\usage{
knn.graph(
  x,
  row.names = NULL,
  k = NULL,
  max.dist = NULL,
  long.lat = FALSE,
  drop.lower = FALSE
)
}
\arguments{
\item{x}{sf POINTS object}

\item{row.names}{Unique row.names assigned to results}

\item{k}{K nearest neighbors, defaults to saturated (n(x) - 1)}

\item{max.dist}{Maximum length of an edge (used for distance constraint)}

\item{long.lat}{(FALSE/TRUE) Coordinates are longitude-latitude decimal degrees,
in which case distances are measured in kilometers}

\item{drop.lower}{(FALSE/TRUE) Drop lower triangle of matrix representing
duplicate edges ie, from-to and to-from}
}
\value{
SpatialLinesDataFrame object with:
\itemize{
\item i        Name of column in x with FROM (origin) index
\item j        Name of column in x with TO (destination) index
\item from_ID  Name of column in x with FROM (origin) region ID
\item to_ID    Name of column in x with TO (destination) region ID
\item length   Length of each edge (line) in projection units or kilometers if not projected
}
}
\description{
Creates a kNN or saturated graph SpatialLinesDataFrame object
}
\note{
...
}
\examples{
 library(sf)
   data(ralu.site, package="GeNetIt")

 # Saturated spatial graph
 sat.graph <- knn.graph(ralu.site, row.names=ralu.site$SiteName)
   head(sat.graph)
 
 # Distanced constrained spatial graph
 dist.graph <- knn.graph(ralu.site, row.names=ralu.site$SiteName, 
                         max.dist = 5000)

opar <- par(no.readonly=TRUE)
 par(mfrow=c(1,2))	
plot(st_geometry(sat.graph), col="grey")
  points(st_coordinates(ralu.site), col="red", pch=20, cex=1.5)
     box()
     title("Saturated graph")	
plot(st_geometry(dist.graph), col="grey")
  points(st_coordinates(ralu.site), col="red", pch=20, cex=1.5)
     box()
     title("Distance constrained graph")
par(opar)	  
	
}
\references{
Murphy, M. A. & J.S. Evans. (in prep). "GenNetIt: gravity analysis in R for landscape
genetics"

Murphy M.A., R. Dezzani, D.S. Pilliod & A.S. Storfer (2010) Landscape genetics of
high mountain frog metapopulations. Molecular Ecology 19(17):3634-3649
}
\author{
Jeffrey S. Evans  \href{mailto:jeffrey_evans@tnc.org}{jeffrey_evans@tnc.org} and
Melanie A. Murphy \href{mailto:melanie.murphy@uwyo.edu}{melanie.murphy@uwyo.edu}
}
