% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWexPrec_lib.r
\name{fit.GWex.prec}
\alias{fit.GWex.prec}
\title{fit.GWex.prec}
\usage{
fit.GWex.prec(objGwexObs, parMargin, listOption = NULL)
}
\arguments{
\item{objGwexObs}{object of class \code{\linkS4class{GwexObs}}}

\item{parMargin}{if not NULL, list where each element parMargin[[iM]] 
corresponds to a month iM=1...12 and contains a matrix nStation x 3 of estimated parameters
 of the marginal distributions (EGPD or mixture of exponentials)}

\item{listOption}{list with the following fields:
\itemize{
  \item \strong{th}: threshold value in mm above which precipitation observations are considered to be non-zero (=0.2 by default)
  \item \strong{nLag}: order of he Markov chain for the transitions between dry and wet states (=2 by default)
  \item \strong{typeMargin}: 'EGPD' (Extended GPD) or 'mixExp' (Mixture of Exponentials). 'EGPD' by default
  \item \strong{copulaInt}: 'Gaussian' or 'Student': type of dependence for amounts (='Student' by default)
  \item \strong{isMAR}: logical value, do we apply a Autoregressive Multivariate Autoregressive model (order 1) =TRUE by default
  \item \strong{is3Damount}: logical value, do we apply the model on 3D-amount. =FALSE by default
  \item \strong{nChainFit}: integer, length of the runs used during the fitting procedure. =100000 by default
  \item \strong{nCluster}: integer, number of clusters which can be used for the parallel computation
}}
}
\value{
a list containing the list of options \code{listOption} and the list of estimated parameters \code{listPar}. 
The parameters of the occurrence process are contained in \code{parOcc} and the parameters related to the  precipitation 
amounts are contained in \code{parInt}. Each type of parameter is a list containing the estimates for each month. In \code{parOcc}, we find:

\itemize{
  \item \strong{p01}: For each station, the probability of transition from a dry state to a wet state.
  \item \strong{p11}: For each station, the probability of staying in a wet state.
  \item \strong{list.pr.state}: For each station, the probabilities of transitions for a Markov chain with lag \code{p}.
  \item \strong{list.mat.omega}: The spatial correlation matrix of occurrences \eqn{\Omega} (see Evin et al., 2018).}

In \code{parInt}, we have:

\itemize{
 \item \strong{parMargin}: list of matrices nStation x nPar of parameters for the marginal distributions (one element per Class).
  \item \strong{cor.int}: Matrices nStation x nStation \eqn{M_0}, \eqn{A}, \eqn{\Omega_Z} representing 
  the spatial and temporal correlations between all the stations (see Evin et al., 2018). For the 
  Student copula, \code{dfStudent} indicates the \eqn{\nu} parameter.
  }
}
\description{
estimate all the parameters for the G-Wex model of precipitation
}
\references{
Evin, G., A.-C. Favre, and B. Hingray. 2018. 'Stochastic Generation of Multi-Site 
Daily Precipitation Focusing on Extreme Events.' Hydrol. Earth Syst. Sci.
22 (1): 655-672. doi.org/10.5194/hess-22-655-2018.
}
\author{
Guillaume Evin
}
