\name{averageCORgvecm}
\alias{averageCORgvecm}

\title{
Comparing average residual correlations of GVECM and VECM.
}

\encoding{latin1}

\description{Average pairwise cross-section residual correlations of GVECM and VECM.
}

\usage{averageCORgvecm(out)
}

\arguments{
  \item{out}{
Estimation results object generated by GVECMest
}
}

\details{This function compares the dependency of residuals in VAR and GVAR.
}

\value{

  \item{vecmRSDcor }{A list object of average residual correlations of country-specific VECM}
  \item{gvecmRSDcor}{A list object of average residual correlations of country-specific VECM augmented by foreign variables(GVECM)}

}
\references{Mauro Filippo di and Pesaran H. M. (2013) The GVAR Handbook-- Structure and Applications of a Macro Model of the Global Economy for Policy. Oxford University Press.
}

\author{Ho Tsung-wu <tsungwu@ntnu.edu.tw>, College of Management, National Taiwan Normal University.
}

\examples{
data("PriceVol")
data("tradeweight1")
data("tradeweightx")
p=2
FLag=2
lag.max=15
type="const"
ic="SC"
weight.matrix=tradeweightx
mainOUTPUT = GVECMest(data=PriceVol,p,lag.max,type,ic,weight.matrix)

cor2_avg=averageCORgvecm(out=mainOUTPUT)
as.matrix((cor2_avg$vecmRSDcor)[[1]])
as.matrix((cor2_avg$vecmRSDcor)[[2]])

as.matrix(cor2_avg$gvecmRSDcor[[1]])
as.matrix(cor2_avg$gvecmRSDcor[[2]])

}
