% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Modalregression.R
\name{modal_regression}
\alias{modal_regression}
\title{Bayesian Modal Regression}
\usage{
modal_regression(formula, data, model, ...)
}
\arguments{
\item{formula}{a formula.}

\item{data}{a dataframe.}

\item{model}{a description of the error distribution. Can be one of "FG", "DTP" and "TPSC".}

\item{...}{Arguments passed to \code{rstan::sampling} (e.g. iter, chains).}
}
\value{
A \code{draw} object from the \strong{posterior} package.
}
\description{
Bayesian Modal Regression
}
\details{
The Bayesian modal regression model based on the FG, DTP or TPSC distribution is defined as:
\deqn{Y_{i} = \mathbf{X}_{i} \boldsymbol{\beta} + e_{i},}
where \eqn{e_{i}} follows the FG, DTP or TPSC distribution.

More details of the Bayesian modal regression model can be found at at Liu, Huang, and Bai (2024) \url{https://arxiv.org/pdf/2211.10776}.
}
\examples{
\donttest{
# Save current user's options.
old <- options()
# (Optional - Running Multiple Chains in Parallel)
options(mc.cores = 2)

if (require(MASS)) { # Need Boston housing data from MASS package.
  # Fit the modal regression based on the FG distribution to the Boston housing data.
  FG_model <- modal_regression(formula = medv ~ .,
                               data = Boston,
                               model = "FG",
                               chains = 2,
                               iter = 2000)
  print(summary(FG_model), n = 17)

  # Fit the modal regression based on the TPSC-Student-t distribution to the Boston housing data.
  TPSC_model <- modal_regression(formula = medv ~ .,
                                 data = Boston,
                                 model = "TPSC",
                                 chains = 2,
                                 iter = 2000)
  print(summary(TPSC_model), n = 17)

  # Fit the modal regression based on the DTP-Student-t distribution to the Boston housing data.
  DTP_model <- modal_regression(formula = medv ~ .,
                                data = Boston,
                                model = "DTP",
                                chains = 2,
                                iter = 2000)
  print(summary(DTP_model), n = 17)
}

# reset (all) initial options
options(old)
}
}
\references{
\insertRef{liu2022bayesian}{GUD}
}
