% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{create_title_format}
\alias{create_title_format}
\title{Create a Title Format Configuration}
\usage{
create_title_format(type = "standard", text = "", sep = NULL)
}
\arguments{
\item{type}{Character. Title format type:
\itemize{
\item \code{"standard"}: Default (variable + description + unit)
\item \code{"prefix"}: Adds text before the automatic title
\item \code{"suffix"}: Adds text after the automatic title
\item \code{"full"}: Uses only the specified text as the title
\item \code{"dynamic"}: Builds a title using column values
}}

\item{text}{Character. Text content used for \code{prefix}, \code{suffix}, \code{full}, or a template for \code{dynamic}.}

\item{sep}{Character. The separator between components (only used in \code{"prefix"} or \code{"suffix"} mode). Default is \code{": "}.}
}
\value{
A list with title format configuration parameters.
}
\description{
Creates a configuration list for controlling plot title formatting.
Supports auto-completion for common title format types.
}
\examples{
# Standard auto-generated title
standard_title <- create_title_format()

# Prefix title
prefix_title <- create_title_format(
  type = "prefix",
  text = "Impact on",
  sep = " "
)

# Dynamic title using column values
dynamic_title <- create_title_format(
  type = "dynamic",
  text = "Impact on {Variable} in {Region}"
)
}
\author{
Pattawee Puangchit
}
