% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/One_D_Mapper.R
\name{clust_all_levels}
\alias{clust_all_levels}
\title{Get clusters for all data level}
\usage{
clust_all_levels(
  data,
  samp_in_lev,
  distance_type,
  clustering_type,
  linkage_type,
  optimal_clustering_mode,
  silhouette_threshold,
  num_bins_when_clustering
)
}
\arguments{
\item{data}{Input data matrix whose columns are the individuals
and rows are the features.BR cambiar nombre.}

\item{samp_in_lev}{A list of character vectors with the individuals
included in each of the levels (i.e. each of the intervals of the values
of the filter functions). It is the output of the \code{samples_in_levels}
function.}

\item{distance_type}{Type of distance to be used for clustering.
Choose between correlation ("correlation") and euclidean ("euclidean").}

\item{clustering_type}{Type of clustering method. Choose between
"hierarchical" and "PAM" (“partition around medoids”) options.}

\item{linkage_type}{Linkage criteria used in hierarchical clustering.
Choose between "single" for single-linkage clustering, "complete" for
complete-linkage clustering or "average" for average linkage clustering
(or UPGMA). Only necessary for hierarchical clustering.}

\item{optimal_clustering_mode}{Method for selection optimal number of
clusters. It is only necessary if the chosen type of algorithm is
hierarchical. In this case, choose between "standard" (the method used
in the original mapper article) or "silhouette". In the case of the
PAM algorithm, the method will always be "silhouette". "silhouette".}

\item{silhouette_threshold}{Minimum value of \eqn{\overline{s}}{s-bar} that a set of
clusters must have to be chosen as optimal. Within each interval of the
filter function, the average silhouette values \eqn{\overline{s}}{s-bar} are computed
for all possible partitions from $2$ to $n-1$, where $n$ is the number of
samples within a specific interval. The $n$ that produces the highest value
of \eqn{\overline{s}}{s-bar} and that exceeds a specific threshold is selected as the
optimum number of clusters. If no partition produces an \eqn{\overline{s}}{s-bar}
exceeding the chosen threshold, all samples are then assigned to a unique
cluster. The default value is $0.25$. The threshold of $0.25$ for
\eqn{\overline{s}}{s-bar} has been chosen based on standard practice, recognizing it
as a moderate value that reflects adequate separation and cohesion within
clusters.}

\item{num_bins_when_clustering}{Number of bins to generate the
histogram employed by the standard optimal number of cluster finder
method. Parameter not necessary if the "optimal_clust_mode" option
is "silhouette" or the "clust_type" is "PAM".}
}
\value{
List of interger vectors. Each of the vectors contains information
about the nodes at each level and the individuals contained in them. The
names of the vector values are the names of the samples and the vector
values are the node number of that level to which the individual belongs.
}
\description{
It performs the clustering of the samples in each
of the levels. That is to say, in each interval of values of the
filtering function, the samples with a value within that interval
are clustered using the proposed clustering algorithm and the
proposed method to determine the optimal number of clusters.
}
