% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgreen_plots.R
\name{select_params}
\alias{select_params}
\title{Selection of best calibration parameters}
\usage{
select_params(df_cb, param)
}
\arguments{
\item{df_cb}{data frame. The result of the calibration process.}

\item{param}{numeric. Goodness-of-fit measures. "NSE", "rNSE", "NSE",
"mNSE", "MAE", "PBIAS", "cp", "R2",...}
}
\value{
A vector with the 3 parameters
}
\description{
Return the best calibration parameter set according to one
goodness-of-fit metric
}
\examples{
\donttest{
# the data of the TN scenario
data(catch_data_TN)
data(annual_data_TN)
# the parameter for the calibration of the model
n_iter <- 2 # number of iterations
# the lower limits for all params (alpha_P, alpha_L, sd_coef)
low <- c(10, 0.000, 0.1)
# the upper limits for all params (alpha_P, alpha_L, sd_coef)
upp <- c(70, 0.3,  0.9)
# years in which the model should be executed
years <- 1990:2018
# execution of the calibration
df_calib <- calib_green(catch_data_TN, annual_data_TN, n_iter, low, upp,
years)
# Extract the best set of parameter according to a Goodnes of fit metric
gof_mes <- "NSE"
NSE_bestParams <- select_params(df_calib, gof_mes)
}

}
