% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordering_functions.R
\name{order_maxmin_exact_obs_pred}
\alias{order_maxmin_exact_obs_pred}
\title{Maximum minimum distance ordering for prediction}
\usage{
order_maxmin_exact_obs_pred(locs, locs_pred)
}
\arguments{
\item{locs}{Observation locations}

\item{locs_pred}{Prediction locations}
}
\value{
A vector of indices giving the ordering, i.e.
the first element of this vector is the index of the first location.
}
\description{
Return the indices of an exact maximum-minimum distance ordering.
The first point is chosen as the "center" point, minimizing L2 distance.
Dimensions d=2 and d=3 handled separately, dimensions d=1 and d>3 handled similarly.
Algorithm is exact and scales quasilinearly.
}
\examples{
n=100; locs <- cbind(runif(n),runif(n))
locs_pred = cbind(runif(n), runif(n))
ord <- order_maxmin_exact_obs_pred(locs, locs_pred)

}
