% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regSeries.R
\name{regSeries}
\alias{regSeries}
\title{Estimates the monomial time series}
\usage{
regSeries(nVar, dMax, series, dMin = 0, pReg = NULL)
}
\arguments{
\item{nVar}{Number of variables considered in the polynomial formulation.}

\item{dMax}{Maximum degree of the polynomial formulation.}

\item{series}{A matrix containing the original time series from which
the monomials are built. Each column corresponds to one given variable.}

\item{dMin}{The minimum negative degree of the polynomial
formulation (0 by default).}

\item{pReg}{A matrix filled, for each column, with powers of time series
used to create.}
}
\value{
\code{rpFull} A matrix of time series. Each column corresponds to one
regressor such as \eqn{X_1^2 X_3 X_4}
}
\description{
Creates time series by multiplying given time series among them.
}
\examples{
data(TSallMod_nVar3_dMax2)
sprottK <- as.matrix(TSallMod_nVar3_dMax2$SprK$reconstr)[,2:4]
dMax <- 2
nVar <- dim(sprottK)[2]

#Example 1
polySeries1 <- regSeries(nVar, dMax, sprottK)

#Example 2
p <- c(1,3,1)
polySeries2 <- regSeries(nVar, dMax, sprottK, pReg=p)

}
\author{
Sylvain Mangiarotti
}
