% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bangkok}
\alias{bangkok}
\title{Bangkok Maximum Rainfall Data}
\format{
A data frame with 58 rows and 5 columns:
\describe{
  \item{X1}{Annual maximum daily rainfall in mm (numeric)}
  \item{X2}{2nd largest annual daily rainfall in mm (numeric)}
  \item{X3}{3rd largest annual daily rainfall in mm (numeric)}
  \item{X4}{4th largest annual daily rainfall in mm (numeric)}
  \item{X5}{5th largest annual daily rainfall in mm (numeric)}
}
}
\source{
Thai Meteorological Department (TMD; \url{https://www.tmd.go.th})
}
\usage{
bangkok
}
\description{
Annual maximum daily rainfall data from Bangkok, Thailand.
This dataset is used for demonstrating model averaging methods
for high quantile estimation in extreme value analysis.
}
\examples{
data(bangkok)
head(bangkok)

# Estimate high quantiles using model averaging
result <- ma.gev(bangkok$X1, quant = c(0.99, 0.995))
print(result$qua.ma)

}
\references{
Shin, Y., Shin, Y., & Park, J. S. (2026). Model averaging with mixed criteria
for estimating high quantiles of extreme values: Application to heavy rainfall.
\emph{Stochastic Environmental Research and Risk Assessment}, 40(2), 47.
\doi{10.1007/s00477-025-03167-x}
}
\keyword{datasets}
