% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemDynamicMacroeconomic_SpotTrading_3_2.R
\name{gemDynamicMacroeconomic_SpotTrading_3_2}
\alias{gemDynamicMacroeconomic_SpotTrading_3_2}
\title{A Dynamic Macroeconomic General Equilibrium Model with Spot Trading}
\usage{
gemDynamicMacroeconomic_SpotTrading_3_2(
  alpha.firm = 1,
  es.prod.lab.firm = 1,
  beta.prod.firm = 0.35,
  depreciation.rate = 0.06,
  eis = 1,
  Gamma.beta = 0.97,
  es.prod.lab.consumer = 1,
  beta.prod.consumer = 0.4,
  gr = 0,
  wage.payment = "post",
  ...
)
}
\arguments{
\item{alpha.firm}{a positive scalar, indicating the efficiency parameter of the firm.}

\item{es.prod.lab.firm}{the elasticity of substitution between product and labor in the production function of firm 1.}

\item{beta.prod.firm}{the share parameter of the product in the production function.}

\item{depreciation.rate}{the physical depreciation rate of capital stock.}

\item{eis}{the elasticity of intertemporal substitution of the consumer.}

\item{Gamma.beta}{the subjective discount factor of the consumer.}

\item{es.prod.lab.consumer}{the elasticity of substitution between product and labor in the CES-type period utility function of the consumer.}

\item{beta.prod.consumer}{the share parameter of the product in the period utility function.}

\item{gr}{the growth rate of the labor supply.}

\item{wage.payment}{a character string specifying the wage payment method, must be one of "pre" or "post".
See the note below.}

\item{...}{arguments to be passed to the function sdm2.}
}
\value{
A general equilibrium (see \code{\link{sdm2}}).
}
\description{
A dynamic macroeconomic general equilibrium model in sequential form.
}
\note{
In the timeline model and the time-circle model, we refer to the labor provided in period t as labor t,
and the product produced using labor t as product t+1.
When the consumer's period utility function simultaneously includes both labor (or leisure) and product,
we can adopt one of two assumptions: either we assume that the period utility function of the consumer in period t
includes labor t and product t, or we assume it includes labor t and product t+1.
These two assumptions are referred to as the wage prepayment assumption and the wage postpayment assumption, respectively.
}
\examples{
\donttest{
#### Take the wage postpayment assumption.
ge <- gemDynamicMacroeconomic_SpotTrading_3_2()
ge$p
ge$z
addmargins(ge$D, 2)
addmargins(ge$S, 2)

#### Take the wage prepayment assumption.
ge <- gemDynamicMacroeconomic_SpotTrading_3_2(wage.payment  = "pre")
ge$p
ge$z
ge$D
ge$S

#### Take the wage prepayment assumption.
ge <- gemDynamicMacroeconomic_SpotTrading_3_2(
  es.prod.lab.firm = 0.8,
  eis = 0.8, es.prod.lab.consumer = 0.8, gr = 0.03,
  wage.payment  = "pre"
)
ge$p
ge$z
ge$D
ge$S

#### an example of steady-state equilibrium at
# http://gecon.r-forge.r-project.org/models/rbc.pdf
ge <- gemDynamicMacroeconomic_SpotTrading_3_2(
  beta.prod.firm = 0.36,
  depreciation.rate = 0.025,
  Gamma.beta = 0.99,
  eis = 0.5,
  beta.prod.consumer = 0.3,
)

ge$p / ge$p[1]
addmargins(ge$D, 2)
addmargins(ge$S, 2)
}
}
\seealso{
\code{\link{gemCanonicalDynamicMacroeconomic_Timeline_2_2}},\cr
\code{\link{gemCanonicalDynamicMacroeconomic_TimeCircle_2_2}},\cr
\code{\link{gemCanonicalDynamicMacroeconomic_Sequential_WagePostpayment_4_3}}.
}
