#' @export
#' @title An Example of an Intertemporal Equilibrium Model with Exhaustible Resources
#' @aliases gemIntertemporal_ExhaustibleResources_3_2
#' @description An example of an intertemporal equilibrium model with three types of commodities (i.e., product, labor and coal) and
#' two types of agents (i.e., firms and a consumer).
#'
#' @param ... arguments to be passed to the function sdm2.
#' @examples
#' \donttest{
#' np <- 10 # the number of economic periods
#'
#' n <- 2 * np + 1 # the number of commodity kinds
#' m <- np + 1 # the number of agent kinds
#'
#' names.commodity <- c(paste0("prod", 1:np), paste0("lab", 1:np), "coal")
#' names.agent <- c(paste0("firm", 1:np), "consumer")
#'
#' # the exogenous supply matrix.
#' S0Exg <- matrix(NA, n, m, dimnames = list(names.commodity, names.agent))
#' S0Exg[paste0("lab", 1:np), "consumer"] <- 100
#' S0Exg["coal", "consumer"] <- 100
#'
#' # the output coefficient matrix.
#' B <- matrix(0, n, m, dimnames = list(names.commodity, names.agent))
#' for (k in 1:np) {
#'   B[paste0("prod", k), paste0("firm", k)] <- 1
#' }
#'
#' dstl.firm <- list()
#' for (k in 1:np) {
#'   dstl.firm[[k]] <- node_new(
#'     "prod",
#'     type = "Leontief", a = c(1, 0.1),
#'     "coal", paste0("lab", k)
#'   )
#' }
#'
#' Gamma.beta <- 0.8
#' eis <- 0.8
#' es <- 1
#' dst.consumer <- node_new(
#'   "util",
#'   type = "CES", es = eis,
#'   alpha = 1, beta = prop.table(Gamma.beta^(1:np)),
#'   paste0("cc", 1:np)
#' )
#' for (k in 1:np) {
#'   node_set(dst.consumer, paste0("cc", k),
#'            type = "CES", es = es,
#'            alpha = 1, beta = c(0.5, 0.5),
#'            paste0("lab", k), paste0("prod", k)
#'   )
#' }
#'
#' f <- function(dstl = c(dstl.firm, dst.consumer)) {
#'   sdm2(
#'     A = dstl,
#'     B = B,
#'     S0Exg = S0Exg,
#'     names.commodity = names.commodity,
#'     names.agent = names.agent,
#'     numeraire = "lab1",
#'     ts = TRUE
#'   )
#' }
#'
#' ge <- f()
#' ge$p
#' ge$z
#'
#' node_set(dst.consumer, "util", beta = rep(1 / np, np))
#' ge2 <- f()
#' ge2$p
#' ge2$z
#' }


gemIntertemporal_ExhaustibleResources_3_2 <- function(...) sdm2(...)
