% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPI_detect.R
\name{remove_short_transitions}
\alias{remove_short_transitions}
\title{Remove Short Transitions}
\usage{
remove_short_transitions(cpts_var_df, cut_times, minimum_event_duration)
}
\arguments{
\item{cpts_var_df}{Calculated changepoints data frame.}

\item{cut_times}{Start of day transitions data frame.}

\item{minimum_event_duration}{The minimum interval between changepoint transitions.}
}
\value{
Data frame of all transitions including start of day with short transitions removed.
}
\description{
Remove Short Transitions
}
\details{
Identify and remove transitions shorter than the minimum event duration.
}
\examples{
changepoints <- data.frame(
  time = c(1677855218, 1677855598, 1677855661, 1677855679),
  index = c(86019, 86399, 62, 80),
  day = c(1, 1, 2, 2)
)
cut_times <- data.frame(time = 1677855600, index = 1, day = 2)
transitions <- remove_short_transitions(changepoints, cut_times, 5)
}
