% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gareg_knots.R
\name{Popinitial_fixknots}
\alias{Popinitial_fixknots}
\title{Fixed-Knots Population Initializer}
\usage{
Popinitial_fixknots(
  popSize,
  prange = NULL,
  N,
  minDist,
  Pb,
  mmax,
  lmax,
  fixedknots
)
}
\arguments{
\item{popSize}{Integer; number of individuals (columns).}

\item{prange}{Optional hyperparameter range (unused here).}

\item{N}{Series length.}

\item{minDist}{Integer minimum spacing between adjacent changepoints.}

\item{Pb}{Unused placeholder (kept for compatibility).}

\item{mmax, lmax}{Integers; maximum number of knots and chromosome length.}

\item{fixedknots}{Integer; number of knots to place.}
}
\value{
Integer matrix of size \code{lmax x popSize}; each column is a
  chromosome \code{c(m, tau_1, ..., tau_m, N+1, ...)}.
}
\description{
Initializes a population matrix for the fixed-knots GA. Each column is a
feasible chromosome sampled by \link{selectTau_uniform_exact}.
}
\seealso{
\link{selectTau_uniform_exact}, \link{gareg_knots}
}
