#' Glycogen content of rat livers
#'
#' Duplicate readings were made on each of three preparations of rat livers
#' from each of two rats for three different treatments (Sokal & Rohlf, 1995).
#'
#' \itemize{
#'   \item treat: a fixed factor with three levels
#'   \item rat: a random factor with two levels nested in treat
#'   \item liver: sample size
#'   \item glycog: response variable
#' }
#'
#' @docType data
#' @keywords datasets
#' @name rats
#' @usage data(rats)
#' @format A data frame with 36 rows and 4 variables
#' @references Sokal, R.R., Rohlf, F.J. 1995. \emph{Biometry}: The Principles and Practice of Statistics in Biological Research. 3rd Edition. W.H. Freeman and Co., New York.
#' @examples
#' library(GAD)
#' data(rats)
#' rats
NULL
